/*jslint browser: true*/
/*global $, webshims*/

// this add support for webshims and jquery >= 1.12.0
// issue https://github.com/aFarkas/webshim/issues/560
jQuery.swap = function( elem, options, callback, args ) {
    var ret, name, old = {};
    // Remember the old values, and insert the new ones
    for ( name in options ) {
            old[ name ] = elem.style[ name ];
            elem.style[ name ] = options[ name ];
    }

    ret = callback.apply( elem, args || [] );

    // Revert the old values
    for ( name in options ) {
            elem.style[ name ] = old[ name ];
    }
    return ret;
};

$(document).ready(function () {
	// if library webshims is linked, activate it
	if (typeof webshims !== "undefined") {
		webshims.polyfill('forms forms-ext');
	}
});

function AsyncRenderControl(id, parentSelector, htmlTag) {
	var elem = document.getElementById(id);
	if (elem === null && parentSelector === "") {
		return false;
	}
	if (elem === null) {
		var scrp = $(parentSelector).children('script');
		if (scrp.length === 0) {
			$(parentSelector).append(htmlTag);
		} else {
			$(scrp[0]).before(htmlTag);
		}
	} else {
		$("#" + id).replaceWith(htmlTag);
	}
	var formTag = $("body > form[name='SubmitForm']");
	var hidInpt;
	var hidName;
	$("#" + id).find('input, select, textarea').each(function () {
		if (this.type == 'radio') {
			hidName = this.id;
		} else {
			hidName = this.name;
		}
		hidInpt = $(formTag).find("input[name='" + hidName + "']");
		if (hidInpt.length === 0) {
			formTag.append('<input type="hidden" name="' + hidName + '">');
		}
	});
	if (typeof webshims !== "undefined") {
		$("#" + id).updatePolyfill();
	}
}

function AsyncDestroyControl(id) {
	var elem = document.getElementById(id);
	if (elem !== null) {
		var formTag = $("body > form[name='SubmitForm']");
		var hidName;
		$(elem).find('input, select, textarea').each(function () {
			if (this.type == 'radio') {
				hidName = this.id;
			} else {
				hidName = this.name;
			}
			$(formTag).find("input[name='" + hidName + "']").remove();
		});
	}
	$("#" + id).remove();
	elem = window[id + "IWCL"];
    if (!elem & IW.String.endsWith(id, "_wrp")) {   // try the wrapper element (modal)
        id = id.substring(0, id.length - 4);
	    elem = window[id + "IWCL"];
    }
	if (elem) {
		elem.IWRelease();
		elem.remove();
	}
}
